package com.liquidnet.service.galaxy.router.zxin.biz;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftEnum;
import com.liquidnet.common.third.zxlnft.dto.*;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyErrorCodeEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishRespDto;
import com.liquidnet.service.galaxy.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxinPublishBiz
 * @Package com.liquidnet.service.galaxy.router.zxin.biz
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 13:05
 */
@Slf4j
@Component
public class ZxinPublishBiz {
    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    @Autowired
    private ZxlnftConfig zxlnftConfig;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private ZxinTradeBiz zxinTradeBiz;

    public ResponseDto<GalaxyNftPublishRespDto> nftPublish(GalaxyNftPublishReqDto reqDto) {
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouteType(),reqDto.getNftOrderPayId());
        if(StringUtil.isNotNull(nftOrderBo)&&StringUtil.isNotEmpty(nftOrderBo.getNftId())){
            return ResponseDto.failure(GalaxyErrorCodeEnum.PUBLISH_FAIL_ALREADY_EXIST.getCode(),GalaxyErrorCodeEnum.PUBLISH_FAIL_ALREADY_EXIST.getMessage());
        }

        //获取用户信息
        GalaxyUserInfoBo userInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouteType(),reqDto.getUserId());

        //获取sku信息
        GalaxySeriesInfoBo seriesInfoBo = dataUtils.getSeriesInfoBo(reqDto.getRouteType(),reqDto.getSkuId());

        String author = seriesInfoBo.getAuthor();
        String nftName = seriesInfoBo.getNftName();
        String nftUrl = seriesInfoBo.getNftUrl();
        String displayUrl = seriesInfoBo.getDisplayUrl();

        String nftDesc = seriesInfoBo.getNftDesc();
        String nftFlag = seriesInfoBo.getNftFlag();
        //发行个数
        Long publishCount = 1L;
        //开始索引
        Integer seriesBeginIndex = 0;
        Long sellCount = Long.valueOf(seriesInfoBo.getSellCount().multiply(BigDecimal.valueOf(100l)).longValue()); //积分
        /**
         * 根据sku获取系列Id
         */
        String seriesId = seriesInfoBo.getSkuId();
        //返回参数nftId
        String nftId = null;
        String taskId = null;


        //查询系列信息
        Nft032SeriesReqDto nft032ReqDto = Nft032SeriesReqDto.getNew();
        nft032ReqDto.setSeriesId(seriesId);
        ZxlnftResponseDto<Nft032SeriesRespDto> resp = zxlnftSdkUtil.nft032Series(nft032ReqDto);

        if(!resp.isSuccess()){
            //该系列已经发行多少个nft
            Long crtCount = resp.getData().getSeriesInfo().getCrtCount();
            log.info("系列：{} 已发行 ：{}", seriesId, crtCount);
            //设置开始索引
            seriesBeginIndex = Integer.parseInt(String.valueOf(crtCount.longValue() + 1));
        }

        //3.1.2调用NFT发行接口
        /**
         * 发行无限制系列
         */
        Nft034PublishReqDto nft034ReqDto = Nft034PublishReqDto.getNew();
        nft034ReqDto.setAuthor(author);
        nft034ReqDto.setName(nftName);
        nft034ReqDto.setUrl(nftUrl);
        nft034ReqDto.setDisplayUrl(displayUrl);
        nft034ReqDto.setDesc(nftDesc);
        nft034ReqDto.setFlag(nftFlag);
        nft034ReqDto.setPublishCount(publishCount);
        //无限制零系列
        nft034ReqDto.setSeriesId(seriesId);
        nft034ReqDto.setSeriesBeginIndex(seriesBeginIndex);
        nft034ReqDto.setSellStatus(Integer.parseInt(ZxlnftEnum.SellStatusEnum.CAN_SELL.getCode()));
        nft034ReqDto.setSellCount(sellCount);
        nft034ReqDto.setOperateId(IDGenerator.get32UUID());
        nft034ReqDto.setMetaData("");

        ZxlnftResponseDto<Nft034PublishRespDto> nft034RespDto = zxlnftSdkUtil.nft034Publish(nft034ReqDto);

        if (nft034RespDto.isSuccess()) {
            //3.1.4查询 NFT发行结果
            Nft035PublishResultReqDto nft035ReqDto = Nft035PublishResultReqDto.getNew();
            taskId = nft034RespDto.getData().getTaskId();
            nft035ReqDto.setTaskId(taskId);

            int count = 0;
            String nftIdBegin = null;
            long timeStart = System.currentTimeMillis();
            while (StringUtil.isEmpty(nftIdBegin)) {
                //休眠1秒钟，等待执行结果
                try {
                    Thread.sleep(1000l);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }

                count++;
                ZxlnftResponseDto<Nft035PublishResultRespDto> nft035RespDtoTemp = zxlnftSdkUtil.nft035PublishResult(nft035ReqDto);
                log.info("=======执行第{}次查询,taskId:{}", count, nft035ReqDto.getTaskId());
                if (nft035RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())) {
                    nftIdBegin = nft035RespDtoTemp.getData().getNftIdBegin();
                } else if (nft035RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())) {
                    log.info("任务执行失败！taskId:{}", nft035ReqDto.getTaskId());
                    return null;
                }

                if (count == 5) {
                    log.info("=======查询共5次，跳出循环！taskId:{}", nft035ReqDto.getTaskId());
                    break;
                }
            }

            //赋值返回参数
            nftId = nftIdBegin;
            log.info("发行NFT后返回给前端nftID:{}", nftIdBegin);
            log.info("总共执行了{}次查询 总耗时:{} MS", count, (System.currentTimeMillis() - timeStart));
        }


        if(StringUtil.isEmpty(nftId)){
            return ResponseDto.failure(GalaxyErrorCodeEnum.PUBLISH_FAIL.getCode(),GalaxyErrorCodeEnum.PUBLISH_FAIL.getMessage());
        }

        GalaxyNftPublishRespDto nftPublishRespDto = GalaxyNftPublishRespDto.getNew();
        nftPublishRespDto.setUserId(reqDto.getUserId());
        nftPublishRespDto.setNftId(nftId);

        //构造缓存数据
        if(nftOrderBo==null){
            nftOrderBo = GalaxyNftOrderBo.getNew();
            nftOrderBo.setUserId(userInfoBo.getUserId());
            nftOrderBo.setSkuId(reqDto.getSkuId());
            nftOrderBo.setSeriesName(seriesInfoBo.getSeriesName());
            nftOrderBo.setSeriesId(seriesInfoBo.getSeriesId());
            nftOrderBo.setNftOrderPayId(reqDto.getNftOrderPayId());
            nftOrderBo.setNftId(nftId);
            nftOrderBo.setNftPrice(seriesInfoBo.getSellCount().longValue());
            nftOrderBo.setFromAddress("");
            nftOrderBo.setToAddress("");
            dataUtils.setNftOrderBo(reqDto.getRouteType(),reqDto.getNftOrderPayId(),nftOrderBo);
        }
        return ResponseDto.success(nftPublishRespDto);
    }
}
