package com.liquidnet.service.order.utils;

import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.HashMap;

@Component
public class QueueUtils {

//    @Autowired
//    private RabbitTemplate rabbitTemplate;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    /**
     * 发送 SqlMapping Json 字符串
     *
     * @param exchange 交换机
     * @param route    路径
     * @param sqlStr   Json字符串
     */
//    public void sendSqlRabbit(String exchange, String route, String sqlStr) {
//            rabbitTemplate.convertAndSend(exchange, route, sqlStr);
//    }

    /**
     * 发送消息 - REDIS
     *
     * @param streamKey Redis消费Key
     * @param jsonMsg   Json字符串
     */
    public void sendMsgByRedis(String streamKey, String jsonMsg) {
        HashMap<String, String> map = ObjectUtil.cloneHashMapStringAndString();
        map.put("message", jsonMsg);
        stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(streamKey));
    }

    public void pushPvUv(String uid, String accessType, String performanceId, String orderId, String orderCode, String ipAddress) {
        try {
            sendMsgByRedis(MQConst.KylinQueue.SQL_PERFORMANCE_LACK.getKey(),
                    SqlMapping.get("bi_ticket_access_records.insert", new Object[]{
                            uid, accessType, performanceId, orderId, orderCode,
                            ipAddress, area, areaProvince, areaCity, areaCounty,
                            LocalDateTime.now(),
                    }));
        } catch (Exception e) {

        }
    }
}
