package com.liquidnet.client.admin.web.controller.zhengzai.kylin;


import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.kylin.service.IKylinExpressModuleService;
import com.liquidnet.service.kylin.dto.param.admin.ExpressModuleFromParam;
import com.liquidnet.service.kylin.entity.KylinExpressModule;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * <p>
 * 快递模板表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-15
 */
@Validated
@Controller
@RequestMapping("/kylin/expressModule")
public class KylinExpressModuleController extends BaseController {
    private String prefix = "zhengzai/kylin/expressModule";

    @Autowired
    private IKylinExpressModuleService expressModuleService;

    @Log(title = "快递模版创建", businessType = BusinessType.INSERT)
    @RequiresPermissions("kylin:expressModule:create")
    @PostMapping("create")
    @ResponseBody
    public AjaxResult create(ExpressModuleFromParam param) {
        Integer result = expressModuleService.createForm(param);
        if (result > 0) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    @Log(title = "快递模版编辑", businessType = BusinessType.UPDATE)
    @RequiresPermissions("kylin:expressModule:update")
    @PostMapping("update")
    @ResponseBody
    public AjaxResult update(ExpressModuleFromParam param) {
        Integer result = expressModuleService.updateForm(param);
        if (result > 0) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    @Log(title = "快递模版上下线", businessType = BusinessType.UPDATE)
    @RequiresPermissions("kylin:expressModule:isOnline")
    @PutMapping("isOnline")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "moduleId", value = "快递模版id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "isOnline", value = "是否上线 1下线 2上线"),
    })
    public AjaxResult isOnline(
            @RequestParam("moduleId") @NotEmpty(message = "moduleId不能为空") String moduleId,
            @RequestParam("isOnline") @NotNull(message = "isOnline不能为空") @Min(value = 1, message = "isOnline无效") @Max(value = 2, message = "isOnline无效") Integer isOnline
    ) {
        Integer result = expressModuleService.isOnline(moduleId, isOnline);
        if (result > 0) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    @Log(title = "快递模版详情", businessType = BusinessType.DETAIL)
    @GetMapping("details")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", required = true, dataType = "String", name = "moduleId", value = "快递模版id"),
    })
    public AjaxResult details(@RequestParam("moduleId") String moduleId) {
        KylinExpressModule result = expressModuleService.detail(moduleId);
        return AjaxResult.success(result);
    }

    @Log(title = "快递模版列表数据", businessType = BusinessType.LIST)
    @RequiresPermissions("kylin:expressModule:list")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo list() {
        PageInfo<KylinExpressModule> result = expressModuleService.expressList();
        return getDataTable(result.getList());
    }

    @GetMapping()
    public String listView() {
        return prefix + "/listView";
    }

    @GetMapping("/create")
    public String createView() {
        return prefix + "/create";
    }

    @GetMapping("/update/{moduleId}")
    public String updateView(@PathVariable("moduleId") String moduleId, ModelMap mmap) {
        KylinExpressModule result = expressModuleService.detail(moduleId);
        mmap.put("KylinExpressModule", result);
        return prefix + "/update";
    }
}
