package com.liquidnet.common.third.zxlnft.dto;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TradeListReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:49
 */
@Data
public class Nft039TradeListRespDto implements Serializable {
    /**
     * 交易信息总数
     */
    private Long total;
    /**
     * 交易信息列表
     */
    private List<TranInfo> transList;

    @Data
    public static class TranInfo{
        /**
         * 持有者地址
         */
        private String fromAddr;
        /**
         * 接收方地址
         */
        private String toAddr;
        /**
         * 成交积分
         */
        private Long dealCount;
        /**
         * 链上交易hash
         */
        private String txHash;
        /**
         * 积分接收地址
         */
        private String pointReceiverAddr;
        /**
         * 链上成交时间
         */
        private Long dealTimestamp;
        /**
         * 交易类别， 1:发行 2:购买 3:转移 4:设置价格 5:设置状态
         */
        private Integer txType;
    }

    private static final Nft039TradeListRespDto obj = new Nft039TradeListRespDto();
    public static Nft039TradeListRespDto getNew() {
        try {
            return (Nft039TradeListRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft039TradeListRespDto();
        }
    }

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }
}
