package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "AdamMemberOrderCallbackParam", description = "购买会员或会员码的支付回调")
@Data
public class AdamMemberOrderCallbackParam implements Serializable, Cloneable {
    private static final long serialVersionUID = -4161563334263071103L;
    private Integer status;
    private String orderCode;
    private String code;
    private String type;
    private BigDecimal price;
    private String paymentType;
    private String paymentAt;
    private String paymentId;

    private static final AdamMemberOrderCallbackParam obj = new AdamMemberOrderCallbackParam();

    public static AdamMemberOrderCallbackParam getNew() {
        try {
            return (AdamMemberOrderCallbackParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberOrderCallbackParam();
        }
    }

    public AdamMemberOrderCallbackParam get(HttpServletRequest servletRequest) {
        this.setStatus(Integer.valueOf(servletRequest.getParameter("status")));
        this.setType(servletRequest.getParameter("type"));
        this.setCode(servletRequest.getParameter("code"));
        this.setOrderCode(servletRequest.getParameter("orderCode"));
        this.setPrice(BigDecimal.valueOf(Double.parseDouble(servletRequest.getParameter("price"))));
        this.setPaymentType(servletRequest.getParameter("paymentType"));
        this.setPaymentAt(servletRequest.getParameter("paymentAt"));
        this.setPaymentId(servletRequest.getParameter("paymentId"));
        return this;
    }
}
