package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 单品兑换码
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsSkuExcode implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 单品ID
     */
    private String skuId;

    /**
     * 生成数量
     */
    private Integer num;

    /**
     * 兑换码类型[0-普通商品|1-数字藏品|2-数字藏品盲盒]
     */
    private Integer type;

    /**
     * 单品兑换码
     */
    private String code;

    /**
     * 兑换码状态[0-未兑换|1-已兑换|10-用作生成模版]
     */
    private Integer state;

    /**
     * 开始时间
     */
    private LocalDateTime startAt;

    /**
     * 截止时间
     */
    private LocalDateTime stopAt;

    /**
     * 兑换用户UID
     */
    private String redeemUid;

    /**
     * 兑换内容描述
     */
    private String redeemFor;

    /**
     * 兑换时间
     */
    private LocalDateTime redeemAt;

    private String operator;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private LocalDateTime deletedAt;

    private String comment;


}
