package com.liquidnet.service.adam.service.processor;

import com.liquidnet.commons.lang.util.ServletUtils;
import com.liquidnet.service.adam.dto.vo.AdamRealInfoVo;
import com.liquidnet.service.adam.entity.AdamRealName;
import com.liquidnet.service.adam.service.DataMigrationProcessorService;
import com.liquidnet.service.adam.service.IAdamRealNameService;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class DMRealNameProcessor extends DataMigrationProcessorService {
    @Autowired
    IAdamRealNameService adamRealNameService;

    @SneakyThrows
    @Override
    protected void dataProcessing() {
        HttpServletRequest request = ServletUtils.getRequest();
        String lS = request.getParameter(DM_LS), flg = StringUtils.defaultIfBlank(request.getParameter(DM_FLG), "");
        if (StringUtils.isNotEmpty(request.getParameter(DM_FLUSH))) {
            log.info("DM.flush.real_name:{}", userMapper.executeForDM("adam_real_name"));

            log.info("DM.flush.AdamRealInfoVo:{}", mongoTemplate.remove(Query.query(Criteria.where("_id").ne(null)), AdamRealInfoVo.class.getSimpleName()).getDeletedCount());
        }

        String sqlCount = "select count(1) from user_real_name where 1=1";
        String field = "id,uid,real_name,id_card,created_at,updated_at";
//                     1-id,2-uid,3-real_name,4-id_card,5-created_at,6-updated_at
        String sql = sqlCount.replace("count(1)", field);

        if ("1".equals(flg)) {
            sqlCount += " and uid in ('2026628','544327','1997335','773650','809406','1167451','423063','677171')";
            sql += " and uid in ('2026628','544327','1997335','773650','809406','1167451','423063','677171')";
        }
        sql += " limit ?,?";

        statement = connection.prepareStatement(sqlCount);
        row = (ResultSetImpl) statement.executeQuery();
        row.first();
        int ct = row.getInt(1), pSize = 1000, num = 0;
        log.info("DM.execute.counts:{}", ct);

        while (ct > 0) {
            statement = connection.prepareStatement(sql);
            int ls = (num == 0 && StringUtils.isNotEmpty(lS)) ? Integer.parseInt(lS) : pSize * num;
            statement.setInt(1, ls);
            statement.setInt(2, pSize);
            row = (ResultSetImpl) statement.executeQuery();
            log.info("DM.execute.limit {},{} ==> begin", ls, pSize);

            List<AdamRealName> realNameList = new ArrayList<>();
            List<AdamRealInfoVo> vos = new ArrayList<>();
            while (row.next()) {
                String uid = row.getString(2);

                if (!reUidList.contains(uid)) {
                    AdamRealName realName = new AdamRealName();
                    realName.setRealNameId(row.getString(1));
                    realName.setUid(uid);
                    realName.setType("1");
                    realName.setName(row.getString(3));
                    realName.setIdCard(row.getString(4));
                    realName.setState(1);
                    realName.setCreatedAt(row.getLocalDateTime(5));
                    realName.setUpdatedAt(row.getLocalDateTime(6));

                    AdamRealInfoVo vo = AdamRealInfoVo.getNew();
                    vo.setUid(uid);
                    vo.setType(realName.getType());
                    vo.setName(realName.getName());
                    vo.setIdCard(realName.getIdCard());
                    vo.setState(1);

//                    realNameMapper.insert(realName);
//                    mongoTemplate.insert(vo, AdamRealInfoVo.class.getSimpleName());
                    realNameList.add(realName);
                    vos.add(vo);
                }
            }
            log.info("DM.execute.limit {},{} ==> handle.counts:{}", ls, pSize, realNameList.size());
            if (!CollectionUtils.isEmpty(realNameList)) {
                mongoTemplate.insert(vos, AdamRealInfoVo.class.getSimpleName());
                log.info("DM.execute.result:{}", adamRealNameService.saveBatch(realNameList));
            }

            num++;
            ct -= pSize;
        }
    }
}
