package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商城-搭售活动详情
 * </p>
 *
 * @author liquidnet
 * @since 2022-06-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinMixDetails implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 混合id
     */
    private String mixId;

    /**
     * 商品类型[1-商城|2-数字藏品]
     */
    private Integer position;

    /**
     * 售卖商品id
     */
    private String spuId;

    /**
     * 售卖商品id
     */
    private String skuId;

    /**
     * 单品现价
     */
    private BigDecimal price;

    /**
     * 苹果商品价格
     */
    private BigDecimal priceV;

    /**
     * 苹果商品价格ID
     */
    private String productId;

    /**
     * 数量[数字藏品默认为1]
     */
    private Integer count;

    /**
     * 是否支持退款[0-否|1-是]
     */
    private Integer canRefund;

    /**
     * 是否删除[0-否|1-是]
     */
    private Integer delTag;

    /**
     * 补充字段
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
