package com.liquidnet.service.sweet.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 失物招领信息返回VO
 *
 * @author liquidnet
 * @since 2025-01-18
 */
@Data
@ApiModel("失物招领信息返回")
public class SweetLostFoundItemVo {

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("物品图片URL")
    private String itemImage;

    @ApiModelProperty("物品描述，最多120字")
    private String description;

    @ApiModelProperty("拾捡地：1-音乐节现场 2-其他")
    private Integer pickupLocation;

    @ApiModelProperty("捡拾日期")
    private String pickupDate;

    @ApiModelProperty("物品类型：1-证件卡类 2-3C数码类 3-服饰类 4-其他")
    private Integer itemType;

    @ApiModelProperty("演出ID")
    private String performanceId;

    @ApiModelProperty("发布人uid")
    private String publisherUid;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

}