package com.liquidnet.service.goblin.service;

import com.liquidnet.service.goblin.dto.vo.*;

import java.util.List;

public interface IGoblinUserDigitalArtworkService {

    GoblinUserDigitalArtworkPageVo page(String uid, Integer pageNum, Integer pageSize);

    /**
     * 获取受赠藏品列表
     *
     * @param uid UID String
     * @return List<GoblinUserDigitalArtworkTransferListVo>
     */
    List<GoblinUserDigitalArtworkTransferListVo> getArtworkListFromTransfer(String uid);

    GoblinUserDigitalArtworkInfoVo info(String uid, String artworkId);

    GoblinUserDigitalArtworkListVo unboxingForBuyOrExchange(String uid, GoblinUserDigitalArtworkVo userDigitalArtworkVo);

    boolean accept(String uid, GoblinUserDigitalArtworkVo userDigitalArtworkVo);

    boolean transfer(GoblinUserDigitalArtworkVo userDigitalArtworkVo, String routerType, String[] receiverArr);

    /**
     * 藏品受赠确认领取
     *
     * @param artworkId 藏品ID
     * @return boolean, true-成功
     */
    boolean transferConfirmReceive(String artworkId);

    /**
     * 藏品受赠确认退还
     *
     * @param artworkId 藏品ID
     * @return boolean, true-成功
     */
    boolean transferConfirmReturn(String artworkId);
}
