package com.liquidnet.service.feign.adam.rsc;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.HashMap;

@Component
@FeignClient(name = "liquidnet-service-stone",
        contextId = "FeignAdamStoneClient", path = "stone",
        url = "${liquidnet.service.stone.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignAdamStoneClient {

    @PostMapping("user/inner/doTask")
    ResponseDto<HashMap<String, Object>> doTaskInner(@RequestParam(value = "taskId") Integer taskId,
                                                     @RequestParam(value = "uid") String uid
    );
}
