package com.liquidnet.service.kylin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

//返回

@Data
@EqualsAndHashCode(callSuper = false)
public class FieldsMisListVo implements Serializable {
    @ApiModelProperty(value = "主键id")
    private String fieldsId;

    @ApiModelProperty(value = "场地名称")
    private String name;

    @ApiModelProperty(value = "封面图")
    private String coverImg;

    @ApiModelProperty(value = "联系地址")
    private String address;

    @ApiModelProperty(value = "省名称")
    private String provinceName;

    @ApiModelProperty(value = "城市名称")
    private String cityName;

    @ApiModelProperty(value = "县名称")
    private String districtName;

    @ApiModelProperty(value = "认证状态 0未认证 1已认证")
    private Integer validStatus;

    @ApiModelProperty(value = "是否显示 0不显示 1显示")
    private Integer isDisplay;

    @ApiModelProperty(value = "是否营业 0不营业 1营业中")
    private Integer isBusiness;

    @ApiModelProperty(value = "审核状态 0待审核 1已审核 2被拒绝")
    private Integer changeStatus;

    @ApiModelProperty(value = "创建时间")
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "修改时间")
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime updatedAt;
}
