/**
 * $Id$
 * Copyright(C) 2015-2020 liquidnet - internet center, All Rights Reserved.
 */
package com.liquidnet.common.exception;


import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.liquidnet.common.exception.constant.ServiceErrorCode;

/**
 * 服务业务异常.
 * 例如当保存一个产品时,该产品已经不存在了,此时可以向客户端抛出这个异常.
 * Created by Administrator on 2017/5/21.
 */
public class LiquidnetFeignException extends HystrixBadRequestException {

	private static final long serialVersionUID = 6454597518532108218L;
    private ServiceErrorCode errorCode;
    private String message;

    public LiquidnetFeignException(String message) {
        super(message);
        this.message = message;
    }

    public LiquidnetFeignException(ServiceErrorCode errorCode, String message){
        super(message);
        this.errorCode = errorCode;
        this.message = message;
    }
    public ServiceErrorCode errorCode() {
        return errorCode;
    }

    @Override
    public String getMessage() {
        return message;
    }
}
