package com.liquidnet.service.base;

import com.liquidnet.commons.lang.util.JsonUtils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Properties;

public class OrderCloseMapping {
    static {
        reload();
    }
    private static Properties sqlsProperties;

    public static void reload() {
        sqlsProperties = new Properties();
        InputStream in = ErrorMapping.class.getClassLoader().getResourceAsStream("sqlmap.properties");
        try {
            sqlsProperties.load(new InputStreamReader(in, StandardCharsets.UTF_8));
            System.out.printf("errorsProperties init count: %s\n", sqlsProperties.size());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String get(String sql) {
        return (String) sqlsProperties.get(sql);
    }

    public static class orderCloseMessage implements Cloneable, Serializable {
        private static final long serialVersionUID = 2208924091512163151L;
        private LinkedList<String> orderTicketIds;

        private orderCloseMessage() {
        }

        public LinkedList<String> getOrderTicketIds() {
            return orderTicketIds;
        }

        public void setOrderTicketIds(LinkedList<String> orderTicketIds) {
            this.orderTicketIds = orderTicketIds;
        }

        private final static OrderCloseMapping.orderCloseMessage instance = new OrderCloseMapping.orderCloseMessage();

        public static OrderCloseMapping.orderCloseMessage getInstance() {
            try {
                return (OrderCloseMapping.orderCloseMessage) instance.clone();
            } catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return new OrderCloseMapping.orderCloseMessage();
        }
    }

    /* ---------------------- ---------------------- ---------------------- */



    public static String get(LinkedList<String> orderTicketIds) {
        OrderCloseMapping.orderCloseMessage sqlMessage = OrderCloseMapping.orderCloseMessage.getInstance();
        sqlMessage.setOrderTicketIds(orderTicketIds);
        return JsonUtils.toJson(sqlMessage);
    }
}
