package com.liquidnet.service.kylin.dto.vo.ticketSystem;

import com.liquidnet.service.kylin.dto.param.ticketSystem.STInsertTicketPriceParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel
public class TicketPriceVo implements Serializable ,Cloneable{
    private static final long serialVersionUID = 4073256621782131607L;
    @ApiModelProperty(value = "演出场次ID [必传]")
    private String performanceId;
    @ApiModelProperty(value = "场次名称 [必传]")
    private String sessionId;
    @ApiModelProperty(value = "票价ID [必传]")
    private String priceId;
    @ApiModelProperty(value = "票价名称 [必传]")
    private String priceName;
    @ApiModelProperty(value = "票价，单位分 [必传]")
    private long ticketPrice;
    @ApiModelProperty(value = "可售库存 [必传]")
    private Integer availableInventory;
    @ApiModelProperty(value = "不可售库存 [必传]")
    private Integer unavailableInventory;

    private static final TicketPriceVo obj = new TicketPriceVo();

    public static TicketPriceVo getNew() {
        try {
            return (TicketPriceVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new TicketPriceVo();
    }
}
