package com.liquidnet.service.kylin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.PayAgainParam;
import com.liquidnet.service.kylin.dto.param.PayOrderParam;
import com.liquidnet.service.kylin.dto.param.SyncOrderParam;
import com.liquidnet.service.kylin.dto.vo.returns.*;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 订单 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
public interface IKylinOrderTicketsService  {

    //订单列表(状态 待支付 已支付 倒计时 已失效)
    PageInfo<List<KylinOrderListVo>> orderList();

    //订单详情
    OrderDetailsVo orderDetails(String orderId);

    //订单未支付数量
    ResponseDto<Integer> orderUnPayCount();

    //想要退款详情
    KylinOrderTicketPreVo toOrderRefundDetails(String orderId);

    //退款详情
    OrderRefundVo orderRefundDetails(String orderId,String orderRefundId);

    /**
     * 发起退款
     * @param orderId                   订单id
     * @param orderTicketEntitiesId     票单id
     * @param reason                    退款原因
     * @param picList                   证据截图
     * @return                          是否成功
     */
    String sendOrderRefund(String orderId, String orderTicketEntitiesId, String reason, String picList);

    //退款撤回
    ResponseDto<Boolean> orderRefundWithdraw(String orderRefundsId);
}
