package com.liquidnet.service.kylin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinApiCameraDevicesVo;
import com.liquidnet.service.kylin.service.impl.KylinCameraServiceImpl;
import com.liquidnet.service.kylin.utils.ObjectUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 人流量排队检测摄像头表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-10
 */
@Api(tags = "人体检测")
@RestController
@RequestMapping("/camera")
@Slf4j
public class KylinCameraController {

    @Autowired
    private KylinCameraServiceImpl cameraService;

    @GetMapping("list")
    @ApiOperation("场地摄像头列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "fieldId", value = "场地ID", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "siteType", value = "地点类型 1卫生间 2。。。"),
    })
    public ResponseDto<List<KylinApiCameraDevicesVo>> cameraList(
            @RequestParam() String fieldId,
            @RequestParam(defaultValue = "0") Integer siteType
    ) {
        try {
            List<KylinApiCameraDevicesVo> result = cameraService.cameraList(fieldId, siteType);
            return ResponseDto.success(result);
        } catch (Exception e) {
            log.error("场地摄像头列表Error", e);
            return ResponseDto.success(ObjectUtil.getKylinApiCameraDevicesVoArrayList());
        }
    }

}
