package com.liquidnet.client.admin.zhengzai.adam.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.commons.lang.util.IdentityUtils;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Slf4j
@Service
public class AdamIdCodeService {
    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;

    public boolean setCertificationJunk(int idType, String idNo, String idName) {
        return redisDataSourceUtil.getRedisAdamUtil().set(AdamRedisConst.INFO_CERTIFICATION_JUNK + idType + idNo, idName, 604800);
    }

    public boolean isCertificationJunk(int idType, String idNo, String idName) {
        String o = (String) redisDataSourceUtil.getRedisAdamUtil().get(AdamRedisConst.INFO_CERTIFICATION_JUNK + idType + idNo);
        return !StringUtils.isEmpty(o) && o.equals(idName);
    }

    /**
     * 目前只针对身份证类型三方服务认证成功的标记
     *
     * @param idType
     * @param idNo
     * @param idName
     * @return
     */
    public boolean setCertification(int idType, String idNo, String idName) {
        return redisDataSourceUtil.getRedisAdamUtil().set(AdamRedisConst.INFO_CERTIFICATION + idType + idNo, idName);
    }

    /**
     * 目前只针对身份证类型三方服务认证成功的标记
     *
     * @param idType
     * @param idNo
     * @param idName
     * @return
     */
    public int isCertification(int idType, String idNo, String idName) {
        String o = (String) redisDataSourceUtil.getRedisAdamUtil().get(AdamRedisConst.INFO_CERTIFICATION + idType + idNo);
        if (StringUtils.isEmpty(o)) {
            return -1;
        }
        return o.equals(idName) ? 1 : 0;
    }

    /**
     * 身份证实名处理
     *
     * @param name
     * @param idCard
     */
    public void identityHandler1(String name, String idCard) {
        String msg = "身份证号与姓名不符";
        String code = "10102";
        int rst = this.isCertification(1, idCard, name);
        switch (rst) {
            // 本地存在，验证不通过 改名字了重新验证
            case 0:
                // 本地不存在
            case -1:
                if (this.isCertificationJunk(1, idCard, name)) {
                    throw new LiquidnetServiceException(code, msg);
                }

                String respStr = IdentityUtils.aliThird(name, idCard), respErrorCode = null;
                JsonNode respJNode = JsonUtils.fromJson(respStr, JsonNode.class);
                if (null == respJNode || !"0".equals(respErrorCode = String.valueOf(respJNode.get("error_code")))) {
                    log.info("###实名认证失败[{}]", respStr);

                    if (!StringUtils.isEmpty(respErrorCode) && org.apache.commons.lang3.StringUtils.indexOf("3000290033", respErrorCode) < 0) {
                        // 认证服务商'30002'、'90033'为运营商导致的失败，这里不做缓存标记
                        this.setCertificationJunk(1, idCard, name);
                    }

                    throw new LiquidnetServiceException(code, msg);
                }

                this.setCertification(1, idCard, name);
                break;
            // 本地存在，验证通过
            case 1:
                break;
            default:
                throw new LiquidnetServiceException(code, "认证失败标记类型错误");
        }
    }

}
