package com.liquidnet.client.admin.web.controller.zhengzai.goblin;


import com.alibaba.fastjson.JSON;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.goblin.service.impl.GoblinFrontNavigationServiceImpl;
import com.liquidnet.service.goblin.entity.GoblinFrontNavigation;
import com.liquidnet.service.goblin.param.GoblinFrontNavigationBuildParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 首页导航栏
 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-28
 */
@Api(tags = "金刚位管理")
@RestController
@RequestMapping("/navigation")
public class GoblinFrontNavigationController extends BaseController {
    @Autowired
    GoblinFrontNavigationServiceImpl goblinFrontNavigationService;
    /***
     * @author zhangfuxin
     * @Description: 添加金刚位
     * @date 2021/12/28 上午11:22
     */
    @PostMapping("createOrUpdate")
    @ApiOperation(value = "增加或者金刚位")
    @ResponseBody
    public AjaxResult createOrUpdate(@RequestBody List<GoblinFrontNavigationBuildParam> list) {
        ArrayList<GoblinFrontNavigation> arrayList=new ArrayList();
        for(GoblinFrontNavigationBuildParam goblinFrontNavigationBuildParam1:list){
            GoblinFrontNavigation goblinFrontNavigation=new GoblinFrontNavigation();
            BeanUtils.copyProperties(goblinFrontNavigationBuildParam1,goblinFrontNavigation);
            arrayList.add(goblinFrontNavigation);
        }

        logger.info("增加金刚位{}", JSON.toJSONString(list));
        boolean result=goblinFrontNavigationService.createOrUpdate(arrayList);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
   /*
    *//**
     * @author zhangfuxin
     * @Description:修改金刚位
     * @date 2021/12/28 上午11:23
     *//*
    @PostMapping("update")
    @ApiOperation(value = "修改金刚位")
    @ResponseBody
    public AjaxResult update( @RequestBody GoblinFrontNavigationBuildParam goblinFrontNavigationBuildParam) {
        GoblinFrontNavigation goblinFrontNavigation=new GoblinFrontNavigation();
        BeanUtils.copyProperties(goblinFrontNavigationBuildParam,goblinFrontNavigation);
        logger.info("修改金刚位{}", JSON.toJSONString(goblinFrontNavigation));
        boolean result=goblinFrontNavigationService.update(goblinFrontNavigation);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }*/
    /**
     *  删除金刚位
     */
    @PostMapping("delete")
    @ApiOperation(value = "删除金刚位")
    @ResponseBody
    public AjaxResult delete( @RequestBody GoblinFrontNavigationBuildParam goblinFrontNavigationBuildParam) {
        GoblinFrontNavigation goblinFrontNavigation=new GoblinFrontNavigation();
        BeanUtils.copyProperties(goblinFrontNavigationBuildParam,goblinFrontNavigation);
        logger.info("删除金刚位{}", JSON.toJSONString(goblinFrontNavigation));
        boolean result=goblinFrontNavigationService.delete(goblinFrontNavigation.getMid());
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    /**
     * 分页金刚位
     *//*
    @PostMapping("page")
    @ApiOperation(value = "分页")
    @ResponseBody
    public AjaxResult page( @RequestParam(name = "pageSize", required = true) int pageSize,@RequestParam(name = "pageNumber", required = true)int pageNumber,@RequestBody GoblinFrontNavigationBuildParam goblinFrontNavigationBuildParam) {
        GoblinFrontNavigation goblinFrontNavigation=new GoblinFrontNavigation();
        BeanUtils.copyProperties(goblinFrontNavigationBuildParam,goblinFrontNavigation);
        logger.info("分页金刚位{}", JSON.toJSONString(goblinFrontNavigation));
        return AjaxResult.success(goblinFrontNavigationService.page(pageSize,pageNumber,null));
    }*/

    @PostMapping("list")
    @ApiOperation(value = "list")
    @ResponseBody
    public AjaxResult list( ) {
        return AjaxResult.success(goblinFrontNavigationService.listGoblinFrontNavigation());
    }
    /**
     * @author zhangfuxin
     * @Description:查看金刚位
     * @date 2021/12/28 上午11:24
     */
    @PostMapping("getOne")
    @ApiOperation(value = "查看金刚位")
    @ResponseBody
    public AjaxResult getOne( @RequestBody GoblinFrontNavigationBuildParam goblinFrontNavigationBuildParam) {
        GoblinFrontNavigation goblinFrontNavigation=new GoblinFrontNavigation();
        BeanUtils.copyProperties(goblinFrontNavigationBuildParam,goblinFrontNavigation);
        logger.info("修改banner{}", JSON.toJSONString(goblinFrontNavigation));
         goblinFrontNavigation=goblinFrontNavigationService.getOne(goblinFrontNavigation.getMid());
        return AjaxResult.success(goblinFrontNavigation);
    }
}
