package com.liquidnet.service.goblin.entity;

import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 兑换码定时任务生成副表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-04-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftExCodeTaskRelation implements Serializable {

    private static final long serialVersionUID = 1L;

    private String mid;

    /**
     * 定时id
     */
    private String taskId;

    /**
     * sku_id
     */
    private String skuId;

    /**
     * 库存
     */
    private Integer stock;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private  final  static GoblinNftExCodeTaskRelation obj = new GoblinNftExCodeTaskRelation();

    public static GoblinNftExCodeTaskRelation getNew(){
        try {
            return  (GoblinNftExCodeTaskRelation) obj.clone();
        }catch (CloneNotSupportedException e){
            return new GoblinNftExCodeTaskRelation();
        }
    }


}
