package com.liquidnet.service.galaxy;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftUploadTempSecretBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestRedisUtil
 * @Package com.liquidnet.service.galaxy
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 16:26
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestRedisUtil {
//    @Autowired
//    private RedisDataSourceUtil redisUtil;

    @Autowired
    private RedisUtil redisUtil;

    private long keyExpireTime = 3600*24*30;

    @Autowired
    private GalaxyDataUtils dataUtils;

    @Test
    public void testdd(){
//        ZxlnftResponseDto responseDto = new ZxlnftResponseDto();

    }

    @Test
    public void testSeriesNftUploadTempSecretBo(){
        String uploadSeriesName = "11111111";
        GalaxySeriesNftUploadTempSecretBo userInfoBo = GalaxySeriesNftUploadTempSecretBo.getNew();
        userInfoBo.setTempSecretId("AKIDmmC9x9YypxXVcjE1_2WQiF2bl-6hjK2rSCL41KZAQ7ww3PRUdxIo7smIkiNNR42A");
        userInfoBo.setTempSecretKey("/kqQu5LtPB+QgKu9qxSGPpc2gRGqxI2/Y7mmGsKMunk=");
        userInfoBo.setSessionToken("7iDfIMWATI4RHfwyI8y7ayi797w4XH6ad8ff7ac1551061438ecdc80ca75a02a1C7w2Ik6j3f4OR-mJFVEDbBTECA-ZQAoizRqoeU-ngT3hboSVFvxH5Q7m8YiccL805oXIKtEBs-9y1jg1sCA8EaarPXZsqG0rHzG5M9mJouoYKOu1W5wo8U-01X2s5zOtDmN1A-NS6JbAm0USePfVRcDlBX0eJ-4Hn6I-Gkf6g-ZeuB2Y9d4HRCiAbdJgjAPVaP_c4On6ae1WZhX5WynRPk31l-iI91k616h32ID81WbVBqbh0ZPR2c_ojy12tB2OWuQjArHVJ7WsW037WVU3LR2W_ulXH3jiD1wjBxBvWjVR3LJnIp4muomYGSu1a4bpaAhDsirm1rj4JDHWvcQDX0H-nzgkh6_ts3veOrUmeXayNwd0s-WzQnhLPn7F9x9jGDqVUFgLq2dr5OvEnENw73qpE9lU8TFqwwbDMgu9ofnLORwhwRPF7Bd3zYeBadCgE3K-BnuQ7ibs7rKoDg4uI_lrelvVrjAQuGPdodpiCqScekyWjm6uucqsKu7rtzO6-ucE6ai6EtLVCAvqAtQsMRUdWbZtc0J3yFCEKuIXVyfG-Dy202LnWV2_av4iSLcpGMEre7k14g21FfdLLDOxzbJEHpFHlkiLJEguJ0A4I-EgStyRUAtCd-q0JNNMUkoV5rzUONM184dn58e_IUwD53mcioL0CaBKzCJXtSb7CWnxdvNT8vlJ53TQbkMlh2q-qlFAL7QZaQRKFymRO_GU44s1KgrGWLsM2AuofxVKH1fZbXk7KiRV6FtwYbFuXr1DGN6sr1asAZOSIFBAvR7aUaKQfs1ljLIf8iWvyYrU3pM");
        userInfoBo.setUploadAddress("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/NOW_ZXL_NFT_PIC001_test_skuId001/");
        userInfoBo.setTimestamp(DateUtil.getNowTime());
        dataUtils.setSeriesNftUploadTempSecretBo(uploadSeriesName,userInfoBo);

        GalaxySeriesNftUploadTempSecretBo seriesNftUploadTempSecretBo = dataUtils.getSeriesNftUploadTempSecretBo(uploadSeriesName);
        System.out.println(seriesNftUploadTempSecretBo.toString());
    }

    @Test
    public void testSet(){
        String userId = "test123";
        GalaxyUserInfoBo userInfoBo = GalaxyUserInfoBo.getNew();
        userInfoBo.setUserId(userId);

        String key = GalaxyConstant.REDIS_KEY_GALAXY_USER.concat(GalaxyEnum.RouterTypeEnum.ZXINCHAIN.getCode()).concat(":") + userId;
//        redisUtil.getRedisGalaxyUtil().set(key,userInfoBo,keyExpireTime);
    }
    @Test
    public void testGetNftIdNo(){
        String routerType = "zxinchain";
        String skuId = "1234567890-sku-010";
//        redisUtil.set(GalaxyConstant.REDIS_KEY_GALAXY_PUBLISH_NFT.concat(routerType).concat(":").concat(skuId),2000);


        long nftIdNo = dataUtils.incrNftIdNo(routerType,skuId);
//        long nftIdNo = dataUtils.getNftIdNo(routerType,skuId);
        System.out.println("skuId:"+skuId+" no:"+nftIdNo+" ");
    }

}
