package com.liquidnet.service.goblin.dto.manage.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.vo.GoblinNftGoodsSkuListVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 预约关联sku和spu表
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-08
 */
@Data
public class AnticipateValueVo implements Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "预约开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutStartDate;
    @ApiModelProperty(value = "预约结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutEndDate;
    @ApiModelProperty("预约状态(0:未开始，1:可预约，2:已结束)")
    private Integer state;
    @ApiModelProperty("预约规则")
    private String rule;
    @ApiModelProperty("预约人数")
    private BigInteger aboutPeople;
    @ApiModelProperty("预约类型（1：预约提醒，2：预约获得购买资格）")
    private Integer type;
    @ApiModelProperty("设置预约人数")
    private Integer peopleType;
    @ApiModelProperty("前三预约头像")
    private List<String> aboutAvatarList;

    private static final AnticipateValueVo obj = new AnticipateValueVo();

    public static AnticipateValueVo getNew() {
        try {
            return (AnticipateValueVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AnticipateValueVo();
        }
    }

    public AnticipateValueVo copy(GoblinGoodsAnticipateValueVo source) {
        this.setRule(source.getRule());
        this.setAboutPeople(source.getAboutPeople());
        this.setAboutStartDate(source.getAboutStartDate());
        this.setAboutEndDate(source.getAboutEndDate());
        this.setState(source.getState());
        this.setType(source.getType());
        this.setPeopleType(source.getPeopleType());
        return this;
    }

}
