package com.liquidnet.service.goblin.param;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value ="GoblinNftExActivityParam",description = "添加方法入参")
@Data
public class GoblinNftExActivityParam implements Serializable {

    @ApiModelProperty(position = 10,required = false,value = "nft活动id")
    private String activityId;

    @ApiModelProperty(position = 11,required = true,value = "活动标题" ,example = "草莓音乐节")
    private String title;

    @ApiModelProperty(position = 12,required = false,value = "开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty(position = 13,required = false,value = "结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty(position = 14,required = true,value = "当前页(查询时传入)")
    private Integer pageNum;

}


