package com.liquidnet.service.goblin.dto.manage.vo;

import com.liquidnet.service.goblin.dto.vo.GoblinGoodsAnticipateShareVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author TT
 */
@Data
@ApiModel(value = "HelpValueVo", description = "根据sid查询助力信息")
public class HelpValueVo implements java.io.Serializable, Cloneable{

    @ApiModelProperty(value = "助力头像前六个")
    private List<String> helpUserAvatar;

    @ApiModelProperty(value = "目前有多少助力")
    private Integer helpPeople;

    @ApiModelProperty("预约类型（1：预约提醒，2：预约获得购买资格）")
    private Integer type;

    @ApiModelProperty("设置预约人数")
    private Integer peopleType;

    @ApiModelProperty("skuId")
    private String skuId;

    @ApiModelProperty("发起助力头像")
    private String avatar;

    @ApiModelProperty("发起人昵称")
    private String nickname;

    private static final HelpValueVo obj = new HelpValueVo();
    public static HelpValueVo getNew() {
        try {
            return (HelpValueVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new HelpValueVo();
        }
    }

    public HelpValueVo copy(GoblinGoodsAnticipateShareVo shareVo){
        if(shareVo == null) return this;
        this.setType(shareVo.getType());
        this.setPeopleType(shareVo.getPeopleType());
        this.setSkuId(shareVo.getSkuId());
        return this;
    }
}
