package com.liquidnet.service.platform.service.impl.goblin;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.entity.GoblinGoodsSku;
import com.liquidnet.service.goblin.entity.GoblinNftExCode;
import com.liquidnet.service.goblin.mapper.GoblinGoodsSkuMapper;
import com.liquidnet.service.goblin.mapper.GoblinNftExCodeMapper;
import com.liquidnet.service.goblin.mapper.GoblinNftExSkuMapper;
import com.liquidnet.service.goblin.param.GoblinNftExCodeParam;
import com.liquidnet.service.goblin.service.IGoblinNftExCodeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author: wll
 * @Description:
 * @Date:Create：in 2022/4/20 5:36 下午
 */
@Service
@Slf4j
public class GoblinNftExCodeServiceImpl implements IGoblinNftExCodeService {

    @Autowired
    private GoblinGoodsSkuMapper goblinGoodsSkuMapper;
    @Autowired
    private GoblinNftExCodeMapper goblinNftExCodeMapper;
    @Autowired
    private GoblinNftExSkuMapper goblinNftExSkuMapper;

    @Override
    public Object selectCodePageList(GoblinNftExCodeParam goblinNftExCodeParam) {

        // 入参
        GoblinNftExCode goblinNftExCode = GoblinNftExCode.getNew();
        goblinNftExCode.setCode(goblinNftExCodeParam.getCode());
        goblinNftExCode.setActivityId(goblinNftExCodeParam.getActivityId());
        goblinNftExCode.setState(goblinNftExCodeParam.getState());
        goblinNftExCode.setRedeemUid(goblinNftExCodeParam.getUserId());
        goblinNftExCode.setIsDrivi(goblinNftExCodeParam.getIsDrivi());
        if (StringUtil.isNotBlank(goblinNftExCodeParam.getSkuName())){
            // 根据藏品名称获取 skuIds
            String skuName = goblinNftExCodeParam.getSkuName();
            List<GoblinGoodsSku> goblinGoodsSkus = goblinGoodsSkuMapper.selectSkuLikeName(skuName);
            if (goblinGoodsSkus.size() <= 0){
                return new PageHelper();
            }
            StringBuffer skuIds = new StringBuffer();
            for (GoblinGoodsSku goblinGoodsSku:goblinGoodsSkus) {
                skuIds.append(goblinGoodsSku.getSkuId()).append(",");
            }
            goblinNftExCode.setSkuId(skuIds.deleteCharAt(skuIds.length()-1).toString());
        }


        PageHelper.startPage(goblinNftExCodeParam.getPageNum(),20,true);
        List<GoblinNftExCode> goblinNftExCodes = goblinNftExCodeMapper.selectGoblinNftCode(goblinNftExCode);
        StringBuffer skuIds = new StringBuffer();
        StringBuffer acticityIds = new StringBuffer();
        for (GoblinNftExCode gnc: goblinNftExCodes) {
            skuIds.append(gnc.getSkuId()).append(",");
            acticityIds.append(gnc.getActivityId()).append(",");
        }

        // 批量查询
        List<GoblinGoodsSku> goblinNftExCodeList =  goblinGoodsSkuMapper.selectByIds(skuIds.toString());


        for (GoblinNftExCode gnc: goblinNftExCodes) {
            for (GoblinGoodsSku goblinGoodsSku: goblinNftExCodeList) {
                if (gnc.getSkuId().equals(goblinGoodsSku.getSkuId())){
                    gnc.setSktName(goblinGoodsSku.getName());
                    break;
                }
            }
        }

        // 根据活动ids 获取兑换活动和sku的关联



        

        PageInfo<GoblinNftExCode> pageInfo = new PageInfo<>(goblinNftExCodes);

        return null;
    }
}
