package com.liquidnet.service.goblin.constant;

public class GoblinStatusConst {
    /* ----------------------------------------------------------------- */
    public enum CommonStatus {
        COMMON_LIMIT_UN(0, "不限购"),
        COMMON_TYPE_ALL(0, "购买条件-全部用户"),
        COMMON_TYPE_MEMBER(1, "购买条件-会员用户"),
        COMMON_TYPE_CAN(2, "购买条件-指定用户"),
        ;

        private final int value;
        private final String desc;

        CommonStatus(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public int getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum OrderStatus {
        ORDER_STATUS_1("1", "订单状态"),
        ;

        private final String value;
        private final String desc;

        OrderStatus(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum MarketingStatus {
        SELF_TYPE_ZHENGZAI(1, "正在下单"),

        STORE_TYPE_PURCHASE(2, "限时秒杀"),

        STORE_PURCHASE_STATUS_ALL(-1, "全部"),
        STORE_PURCHASE_STATUS_UN_START(0, "等待开始"),
        STORE_PURCHASE_STATUS_ING_START(1, "活动中"),
        STORE_PURCHASE_STATUS_END_START(2, "活动结束"),
        STORE_PURCHASE_STATUS_STOP(7, "停用"),
        ;
        private final int value;
        private final String desc;

        MarketingStatus(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public int getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }



    /* ----------------------------------------------------------------- */



    /* ----------------------------------------------------------------- */
}
