package com.liquidnet.service.kylin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.kylin.dao.*;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 订单 Mapper 接口
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 14:00 下午
 */
public interface KylinOrderTicketsMapper extends BaseMapper<KylinOrderTickets> {

    // 查询演出订单能退款的总金额和总订单数量
    HashMap<String, Object> getPerformanceRefundOrderStatis(@Param("targetId") String targetId, @Param("paymentType") String[] paymentType);

    // 获取可退款的订单信息
    List<KylinOrderTickets> getCanRefundOrderList(@Param("targetId") String targetId, @Param("mid") int mid, @Param("limitNum") int limitNum);

    List<OrderTicketsListDao> orderList(Map<String, Object> map);

    List<OrderPushDamaiDto> pushDamaiDetailsList(String ticketsId);

    List<OrderScriptDto> orderScriptDto(String userId);

    List<PerformanceExpressPerformanceOrderListAdminDao> performanceExpressPerformanceOrderList(Map<String, Object> map);

    List<KylinOrderTickets> getCanPlaceOrderList(@Param("performanceId") String performanceId, @Param("mid") int mid, @Param("limitNum") int limitNum);

    List<OrderIdsDao> getOrderUserIdByTimesId(@Param("ticketId") String ticketId);

    List<OrderExpressExportListDao> selectExpressList(@Param("performanceId") String performanceId);

    /**
     * 根据用户id获取 演出订单维度 完成没任务次数
     * @param uid
     * @return
     */
    Integer getOrderScore(@Param("uid") String uid);
    List<Map> getUserOrder(@Param("userId")String userId);
    Map getUserCommission(@Param("agentId")String agentId);
    List<Map> getUserSellOneDate(@Param("agentId")String agentId,@Param("performanceId")String performanceId);
    Map getUserSellAllDate(@Param("agentId")String agentId,@Param("performanceId")String performanceId);
    List<Map> getUserSellDetail(@Param("agentId")String agentId,@Param("ticketId")String ticketId);
    List<Map> getUserPerformance(@Param("agentId")String userId);

    List<KylinOrderTicketAndAgentVo> selectListByPerformanceId(@Param("performancesId") String performancesId);

    List<String> getAgentIdListByPerId(@Param("performancesId") String performancesId);
}
