package com.liquidnet.service.controller;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SmileAgentVo;
import com.liquidnet.service.goblin.dto.vo.SmileUserVO;
import com.liquidnet.service.goblin.service.manage.SmileFrontService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhangfuxin
 * @Description:用户接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端接口管理(不需要登陆)")
@RestController
@RequestMapping("/frontNoLogin")
@Slf4j
public class SmileNoLoginController {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SmileFrontService smileFrontService;

    @PostMapping("getUser")
    @ApiOperation("获取用户状态,并返回票提")
    public ResponseDto<SmileUserVO> getUser(String userId, String performanceId, String ticketId) {
        SmileUserVO smileUserVO = (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
        if (redisUtil.hasKey(SmileRedisConst.SMILE_AGENT.concat(performanceId).concat(":").concat(ticketId))) {
            SmileAgentVo smileAgentVo = (SmileAgentVo) redisUtil.get(SmileRedisConst.SMILE_AGENT.concat(performanceId).concat(":").concat(ticketId));
            smileUserVO.setSmileAgentVo(smileAgentVo);
        }

        return ResponseDto.success(smileUserVO);
    }


}
