package com.liquidnet.client.admin.zhengzai.candy.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponRelateParam;
import com.liquidnet.service.candy.entity.CandyCouponRelate;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 券适用关联配置 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-19
 */
public interface ICandyCouponRelateAdminService extends IService<CandyCouponRelate> {

    /**
     * 券适用关联配置
     *
     * @param couponRelateParam CandyMgtCouponRelateParam
     * @return boolean
     */
    AjaxResult relate(CandyMgtCouponRelateParam couponRelateParam);

    /**
     * 券适用关联巡演名称查询
     *
     * @param couponIdList List<String>
     * @return Map<String, String>
     */
    Map<String, String> queryRelateRoadshowName(List<String> couponIdList);
}
