package com.liquidnet.service.sweet.service.impl.syncRedis;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.dto.vo.admin.AdminUpushVo;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.admin.ZhengzaiAppVersionsVo;
import com.liquidnet.service.kylin.entity.KylinBanners;
import com.liquidnet.service.sweet.entity.SweetWechatUser;
import com.liquidnet.service.sweet.vo.SweetAnswerVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;

@Service
@Slf4j
public class JxlDataImpl {

    @Autowired
    private RedisUtil redisUtil;

    public Boolean basicServicesVersions() {
        RedisTemplate<String, Object> redisTemplateByDb = redisUtil.getRedisTemplateByDb(15);

        String appAndroid = KylinRedisConst.ZHENGZAI_APP_VERSIONS_ANDROID;
        String appIos = KylinRedisConst.ZHENGZAI_APP_VERSIONS_IOS;
        String checkAndroid = KylinRedisConst.ZHENGZAI_APP_VERSIONS_CHECK_ANDROID;
        String checkIos = KylinRedisConst.ZHENGZAI_APP_VERSIONS_CHECK_IOS;

        ZhengzaiAppVersionsVo appAndroidValue = (ZhengzaiAppVersionsVo) redisTemplateByDb.opsForValue().get(appAndroid);
        redisUtil.set(appAndroid, appAndroidValue);
        ZhengzaiAppVersionsVo appIosValue = (ZhengzaiAppVersionsVo) redisTemplateByDb.opsForValue().get(appIos);
        redisUtil.set(appIos, appIosValue);
        ZhengzaiAppVersionsVo checkAndroidValue = (ZhengzaiAppVersionsVo) redisTemplateByDb.opsForValue().get(checkAndroid);
        redisUtil.set(checkAndroid, checkAndroidValue);
        ZhengzaiAppVersionsVo checkIosValue = (ZhengzaiAppVersionsVo) redisTemplateByDb.opsForValue().get(checkIos);
        redisUtil.set(checkIos, checkIosValue);

        return true;
    }

    public Boolean basicServicesUpush() {
        RedisTemplate<String, Object> redisTemplateByDb = redisUtil.getRedisTemplateByDb(15);

        String pushAndroid = KylinRedisConst.ADMIN_UPUSH_LIST_IOS;
        String pushIos = KylinRedisConst.ADMIN_UPUSH_LIST_ANDROID;

        LinkedList<AdminUpushVo> pushAndroidList = (LinkedList<AdminUpushVo>) redisTemplateByDb.opsForValue().get(pushAndroid);
        redisUtil.set(pushAndroid, pushAndroidList);
        LinkedList<AdminUpushVo> pushIosList = (LinkedList<AdminUpushVo>) redisTemplateByDb.opsForValue().get(pushIos);
        redisUtil.set(pushIos, pushIosList);

        return true;
    }

    public Boolean sweetAccessToken() {
//        sweet:accessToken:applet:zhengzai:access_token:wx4732efeaa2b08086
//        sweet:accessToken:applet:strawberry:access_token:wx08b852ade69f8019
        return true;
    }

    public Boolean sweetAnswer() {
        RedisTemplate<String, Object> redisTemplateByDb = redisUtil.getRedisTemplateByDb(15);

        String redisKey = "sweet:answer:phone*";

        Set<String> keys = redisTemplateByDb.keys(redisKey);
        for (String key : keys) {
            SweetAnswerVo answer = (SweetAnswerVo) redisTemplateByDb.opsForValue().get(key);
            redisUtil.set(key, answer);
        }

        return true;
    }

    public Boolean sweetOpenId() {
        RedisTemplate<String, Object> redisTemplateByDb = redisUtil.getRedisTemplateByDb(15);

        String redisKey = "sweet:wechatUser:openId*";

        Set<String> keys = redisTemplateByDb.keys(redisKey);
        for (String key : keys) {
            String value = (String) redisTemplateByDb.opsForValue().get(key);
            redisUtil.set(key, value);
        }

        return true;
    }

    public Boolean sweetUnionId() {
        RedisTemplate<String, Object> redisTemplateByDb = redisUtil.getRedisTemplateByDb(15);

        String redisKey = "sweet:wechatUser:unionId*";

        Set<String> keys = redisTemplateByDb.keys(redisKey);
        for (String key : keys) {
            try {
                SweetWechatUser userInfo = (SweetWechatUser) redisTemplateByDb.opsForValue().get(key);
                redisUtil.set(key, userInfo);
            } catch (Exception e) {
                log.error("同步wechatUser失败"+key, e);
            }
        }

        return true;
    }

    public Boolean sweetUnionIdStr() {
        RedisTemplate<String, Object> redisTemplateByDb = redisUtil.getRedisTemplateByDb(15);

        String redisKey = "sweet:wechatUser:unionIdStr*";

        Set<String> keys = redisTemplateByDb.keys(redisKey);
        for (String key : keys) {
            String value = (String) redisTemplateByDb.opsForValue().get(key);
            redisUtil.set(key, value);
        }

        return true;
    }

    public Boolean kylinBanner() {
        RedisTemplate<String, Object> redisTemplateByDb = redisUtil.getRedisTemplateByDb(15);

        String bannerKey = KylinRedisConst.ADMIN_BANNER_LIST;

        ArrayList<KylinBanners> bannerList = (ArrayList<KylinBanners>) redisTemplateByDb.opsForValue().get(bannerKey);
        redisUtil.set(bannerKey, bannerList);

        return true;
    }
}
