package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinGoodsExtagVo", description = "商品关联音乐人、艺人、IP信息")
@Data
public class GoblinGoodsExtagVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 367926424789690081L;
    @ApiModelProperty(position = 10, value = "标签ID")
    private String tagId;
    @ApiModelProperty(position = 11, value = "标签名称")
    private String tagName;
    @ApiModelProperty(position = 12, value = "标签说明")
    private String tagDesc;
    @ApiModelProperty(position = 13, value = "标签图片")
    private String tagPic;
    @ApiModelProperty(position = 14, value = "排序[数值越小,排序越前]")
    private Integer sort;

    public GoblinGoodsExtagVo setSort(Integer sort) {
        this.sort = sort;
        return this;
    }

    private static final GoblinGoodsExtagVo obj = new GoblinGoodsExtagVo();
    public static GoblinGoodsExtagVo getNew() {
        try {
            return (GoblinGoodsExtagVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsExtagVo();
        }
    }

    public GoblinGoodsExtagVo copy(GoblinSelfTagVo source) {
        if (null == source) return this;
        this.setTagId(source.getTagId());
        this.setTagName(source.getTagName());
        this.setTagDesc(source.getTagDesc());
        this.setTagPic(source.getTagPic());
        return this;
    }
}
