package com.liquidnet.service.feign.kylin.api;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Component
@FeignClient(name = "liquidnet-service-kylin",
        contextId = "FeignKylinPerformanceClient", path = "",
        fallback = FallbackFactory.Default.class)
public interface FeignKylinPerformanceClient {

    // 演出列表
    @GetMapping(value =  "kylin/performance/list")
    ResponseDto<List<KylinPerformanceVo>> performanceList(@RequestParam("performancesIds") String... performancesIds);

    // 演出详情
    @GetMapping("kylin/performance/{performancesId}")
    ResponseDto<KylinPerformanceVo> detail(@PathVariable("performancesId") String performancesId);
}
