package com.liquidnet.service.consumer.dragon.service.config;

import com.liquidnet.service.consumer.dragon.service.receiver.*;
import com.liquidnet.service.dragon.constant.DragonConstant;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

@Configuration
public class RedisStreamConfig2 {

    @Autowired
    private RedisPayReceiver redisPayReceiver;
    @Autowired
    private RedisRefundReceiver redisRefundReceiver;
    @Autowired
    private RedisPayNotifyReceiver redisPayNotifyReceiver;
    @Autowired
    private RedisMchNotifyReceiver redisMchNotifyReceiver;
    @Autowired
    private RedisMchNotifyFailReceiver redisMchNotifyFailReceiver;

    @Bean
    public Subscription subscriptionPay10(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), "dragon-pay-10"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay11(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), "dragon-pay-11"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay12(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), "dragon-pay-12"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay13(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), "dragon-pay-13"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay14(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), "dragon-pay-14"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay15(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), "dragon-pay-15"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay16(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), "dragon-pay-16"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay17(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), "dragon-pay-17"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay18(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), "dragon-pay-18"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPay19(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_GROUP.getCode(), "dragon-pay-19"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionRefund10(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_GROUP.getCode(), "dragon-refund-10"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_KEY.getCode(), ReadOffset.lastConsumed()), redisRefundReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionRefund11(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_GROUP.getCode(), "dragon-refund-11"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_KEY.getCode(), ReadOffset.lastConsumed()), redisRefundReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionRefund12(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_GROUP.getCode(), "dragon-refund-12"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_KEY.getCode(), ReadOffset.lastConsumed()), redisRefundReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionRefund13(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_GROUP.getCode(), "dragon-refund-13"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_KEY.getCode(), ReadOffset.lastConsumed()), redisRefundReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionRefund14(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_GROUP.getCode(), "dragon-refund-14"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_REFUND_KEY.getCode(), ReadOffset.lastConsumed()), redisRefundReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPayNotify10(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_GROUP.getCode(), "dragon-pay-notify-10"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPayNotify11(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_GROUP.getCode(), "dragon-pay-notify-11"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPayNotify12(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_GROUP.getCode(), "dragon-pay-notify-12"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPayNotify13(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_GROUP.getCode(), "dragon-pay-notify-13"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPayNotify14(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_GROUP.getCode(), "dragon-pay-notify-14"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisPayNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionMchNotify10(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_GROUP.getCode(), "pay-mch-notify-10"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionMchNotify11(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_GROUP.getCode(), "pay-mch-notify-11"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }
    @Bean
    public Subscription subscriptionMchNotify12(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_GROUP.getCode(), "pay-mch-notify-12"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionMchNotify13(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_GROUP.getCode(), "pay-mch-notify-13"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionMchNotify14(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_GROUP.getCode(), "pay-mch-notify-14"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyReceiver);
        listenerContainer.start();
        return subscription;
    }
    @Bean
    public Subscription subscriptionPayNotifyFail10(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_GROUP.getCode(), "pay-mch-notify-fail-10"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyFailReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPayNotifyFail11(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_GROUP.getCode(), "pay-mch-notify-fail-11"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyFailReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPayNotifyFail12(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_GROUP.getCode(), "pay-mch-notify-fail-12"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyFailReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPayNotifyFail13(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_GROUP.getCode(), "pay-mch-notify-fail-13"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyFailReceiver);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionPayNotifyFail14(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        var listenerContainer = StreamMessageListenerContainer.create(factory, options);
        var subscription = listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_GROUP.getCode(), "pay-mch-notify-fail-14"),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_ERROR_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyFailReceiver);
        listenerContainer.start();
        return subscription;
    }
}
