package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
public class AdamMemberOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 用户id
     */
    private String uid;
    /**
     * 购买方式:0-购买会员 1-购买会员码,2-使用会员码
     */
    private String mode;
    /**
     * 原价
     */
    private BigDecimal price;
    /**
     * 实际支付价格
     */
    private BigDecimal pricePaid;
    /**
     * 会员名称
     */
    private String memberName;
    /**
     * 会员id
     */
    private String memberId;
    /**
     * 价格id
     */
    private String memberPriceId;
    /**
     * 购买天数
     */
    private Integer days;
    /**
     * 订单状态:0未支付 1已支付 2已超时 5已退款
     */
    private Integer state;
    /**
     * 会员编号
     */
    private String memberNo;
    /**
     * 支付渠道
     */
    private String payChannel;
    /**
     * 支付单号
     */
    private String payNo;
    /**
     * 支付时间
     */
    private LocalDateTime paymentAt;
    /**
     * 用户生日
     */
    private LocalDateTime birthday;
    /**
     * ip地址
     */
    private String clientIp;
    /**
     * 购买来源  Android  iOS  h5
     */
    private String source;
    /**
     * 客户端版本号
     */
    private String version;

    private LocalDateTime createdAt;
    private LocalDateTime updatedAt;


}
