package com.liquidnet.service.consumer.dragon.service.receiver;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.stream.StreamListener;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class RedisPayReceiver implements StreamListener<String, MapRecord<String, String, String>> {

    @Override
    public void onMessage(MapRecord<String, String, String> message) {
        log.info("接受到来自redis PAY 的消息");
        System.out.println("message id "+message.getId());
        System.out.println("stream "+message.getStream());
        System.out.println("body "+message.getValue());
    }
}
