package com.liquidnet.service.goblin.service.impl.inner;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyResultBatchQueryReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyResultBatchQueryRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Galaxy服务接口调用
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2022/4/1
 */
@Slf4j
@Service
public class GoblinGalaxyService {
    @Value("${liquidnet.service.galaxy.url}")
    private String serviceGalaxyUrl;

//    /**
//     * NFT素材上传
//     *
//     * @param nftUploadReqDto GalaxyNftUploadReqDto
//     * @return GalaxyNftUploadRespDto
//     */
//    public GalaxyNftUploadRespDto uploadNftMaterial(GalaxyNftUploadReqDto nftUploadReqDto) {
//        String postUrl = serviceGalaxyUrl + "/galaxy/artwork/nftUpload";
//        String postBody = JsonUtils.toJson(nftUploadReqDto);
//        try {
//            String postRespStr = HttpUtil.postRaw(postUrl, postBody, null);
//            JsonNode postRespJNode = JsonUtils.fromJson(postRespStr, JsonNode.class), postRespCode;
//            if (null == postRespJNode || null == (postRespCode = postRespJNode.get("code")) || !postRespCode.asText().equals("0")) {
//                log.warn("#NFT素材上传:请求失败[paramsStr={},postRespStr={}]", postBody, postRespStr);
//                return null;
//            }
//            return JsonUtils.OM().convertValue(postRespJNode.get("data"), GalaxyNftUploadRespDto.class);
//        } catch (Exception e) {
//            log.error("Ex.NFT素材上传:请求异常[url={},paramsStr={}],ex:{}", postUrl, postBody, e.getMessage());
//            return null;
//        }
//    }
//
//    /**
//     * NFT系列声明
//     *
//     * @param seriesClaimReqDto GalaxyArtSeriesClaimReqDto
//     * @return GalaxyArtSeriesClaimRespDto
//     */
//    public GalaxyArtSeriesClaimRespDto claimNftSeries(GalaxyArtSeriesClaimReqDto seriesClaimReqDto) {
//        String postUrl = serviceGalaxyUrl + "/galaxy/artwork/seriesClaim";
//        String postBody = JsonUtils.toJson(seriesClaimReqDto);
//        try {
//            String postRespStr = HttpUtil.postRaw(postUrl, postBody, null);
//            JsonNode postRespJNode = JsonUtils.fromJson(postRespStr, JsonNode.class), postRespCode;
//            if (null == postRespJNode || null == (postRespCode = postRespJNode.get("code")) || !postRespCode.asText().equals("0")) {
//                log.warn("#NFT系列声明:请求失败[paramsStr={},postRespStr={}]", postBody, postRespStr);
//                return null;
//            }
//            return JsonUtils.OM().convertValue(postRespJNode.get("data"), GalaxyArtSeriesClaimRespDto.class);
//        } catch (Exception e) {
//            log.error("Ex.NFT系列声明:请求异常[url={},paramsStr={}],ex:{}", postUrl, postBody, e.getMessage());
//            return null;
//        }
//    }

    /**
     * NFT发行、购买结果查询
     *
     * @param uid
     * @param orderId
     * @param routerType
     * @return
     */
    public List<String> checkNftTradeResult(String uid, String orderId, String routerType) {
        ObjectNode postBodyNode = JsonUtils.OM().createObjectNode();
        postBodyNode.put("userId", uid);
        postBodyNode.put("nftOrderPayId", orderId);
        postBodyNode.put("routerType", routerType);

        String postUrl = serviceGalaxyUrl + "/galaxy/nftTrade/nftPublishAndBuyResultQuery";
        try {
            String postRespStr = HttpUtil.postRaw(postUrl, postBodyNode.toString(), null);
            JsonNode postRespJNode = JsonUtils.fromJson(postRespStr, JsonNode.class), postRespCode;
            if (null == postRespJNode || null == (postRespCode = postRespJNode.get("code")) || !postRespCode.asText().equals("0")) {
                log.warn("#NFT发行购买结果查询:查询失败[postBody={},postRespStr={}]", postBodyNode, postRespStr);
                return null;
            }
            JsonNode postRespDataJNode = postRespJNode.get("data");

            List<String> respDataList = CollectionUtil.arrayListString();
            respDataList.add(postRespDataJNode.get("nftId").asText());
            respDataList.add(postRespDataJNode.get("nftPublishChainTimestamp").asText());
            respDataList.add(postRespDataJNode.get("nftPublishTradeHash").asText());
            respDataList.add(postRespDataJNode.get("nftBuyChainTimestamp").asText());
            respDataList.add(postRespDataJNode.get("nftBuyTradeHash").asText());
            return respDataList;
        } catch (Exception e) {
            log.error("Ex.NFT发行购买结果查询:请求异常[url={},postBody={}],ex:{}", postUrl, postBodyNode, e.getMessage());
            return null;
        }
    }

    /**
     * NFT发行、购买结果查询
     *
     * @param queryReqDto GalaxyNftPublishAndBuyResultBatchQueryReqDto
     * @return GalaxyNftPublishAndBuyResultBatchQueryRespDto
     */
    public GalaxyNftPublishAndBuyResultBatchQueryRespDto checkNftTradeResultBatch(GalaxyNftPublishAndBuyResultBatchQueryReqDto queryReqDto) {
        String postUrl = serviceGalaxyUrl + "/galaxy/nftTrade/nftPublishAndBuyResultBatchQuery";
        String postBody = JsonUtils.toJson(queryReqDto);
        try {
            String postRespStr = HttpUtil.postRaw(postUrl, postBody, null);
            JsonNode postRespJNode = JsonUtils.fromJson(postRespStr, JsonNode.class), postRespCode;
            if (null == postRespJNode || null == (postRespCode = postRespJNode.get("code")) || !postRespCode.asText().equals("0")) {
                log.warn("#NFT发行购买结果查询:查询失败[postBody={},postRespStr={}]", postBody, postRespStr);
                return null;
            }
            return JsonUtils.OM().convertValue(postRespJNode.get("data"), GalaxyNftPublishAndBuyResultBatchQueryRespDto.class);
        } catch (Exception e) {
            log.error("Ex.NFT发行购买结果查询:请求异常[url={},postBody={}],ex:{}", postUrl, postBody, e.getMessage());
            return null;
        }
    }
}
