package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinStoreMarketRelationVo", description = "前端用 商铺活动 关联 spu sku")
@Data
public class GoblinMarketSpuListVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 2353354057235207502L;
    @ApiModelProperty(position = 11, value = "spuId")
    private String marketSpuId;
    @ApiModelProperty(position = 12, value = "封面图片地址")
    private String coverPic;
    @ApiModelProperty(position = 12, value = "价格区间MIN[20,2]")
    private BigDecimal priceGe;
    @ApiModelProperty(position = 12, value = "价格区间MAX[20,2]")
    private BigDecimal priceLe;
    @ApiModelProperty(position = 12, value = "商品名称")
    private String name;

    private static final GoblinMarketSpuListVo obj = new GoblinMarketSpuListVo();
    public static GoblinMarketSpuListVo getNew() {
        try {
            return (GoblinMarketSpuListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMarketSpuListVo();
        }
    }
}
