package com.baidu.xasset.client.xasset;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: XassetDef
 * @Package com.baidu.xasset.client.xasset
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/8/17 11:52
 */
//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.annotation.JSONField;
import com.baidu.xasset.client.base.BaseDef.RequestRes;

import java.util.Map;

public class XassetDef {
    public static final int ASSETCATEART = 1;
    public static final int ASSETCATECOLLECT = 2;
    public static final int ASSETCATETICKET = 3;
    public static final int ASSETCATEHOTEL = 4;

    public XassetDef() {
    }

    public static class SceneQueryShardsResp {
        public long requestId;
        public int errNo;
        public String errMsg;
        public SceneShardMeta meta;

        SceneQueryShardsResp(long requestId, int errNo, String errMsg, SceneShardMeta meta) {
            this.requestId = requestId;
            this.errNo = errNo;
            this.errMsg = errMsg;
            this.meta = meta;
        }
    }

    public static class SceneShardMeta {
        public long assetId;
        public long shardId;
        public String ownerAddr;
        public long price;
        public int status;
        public String txId;
        public long ctime;
        public String jumpLink;
        public String title;
        public Thumb[] thumb;
        public JSONArray assetUrl;
        public JSONArray imgDesc;
        public String shortDesc;
        public String createAddr;

        SceneShardMeta(long assetId, long shardId, String ownerAddr, long price, int status, String txId, long ctime, String jumbLink, String title, Thumb[] thumb, JSONArray assetUrl, JSONArray imgDesc, String shortDesc, String createAddr) {
            this.assetId = assetId;
            this.shardId = shardId;
            this.ownerAddr = ownerAddr;
            this.price = price;
            this.status = status;
            this.txId = txId;
            this.ctime = ctime;
            this.jumpLink = jumbLink;
            this.title = title;
            this.thumb = thumb;
            this.assetUrl = assetUrl;
            this.imgDesc = imgDesc;
            this.shortDesc = shortDesc;
            this.createAddr = createAddr;
        }
    }

    public static class HasAssetByAddrResp {
        public long requestId;
        public int errNo;
        public String errMsg;
        public Map<String, Integer> result;

        HasAssetByAddrResp(long requestId, int errNo, String errMsg, Map<String, Integer> result) {
            this.requestId = requestId;
            this.errNo = errNo;
            this.errMsg = errMsg;
            this.result = result;
        }
    }

    public static class SceneShardInfo {
        public long assetId;
        public long shardId;
        public String title;
        public Thumb[] thumb;
        public long ctime;

        SceneShardInfo(long assetId, long shardId, String title, Thumb[] thumb, long ctime) {
            this.assetId = assetId;
            this.shardId = shardId;
            this.title = title;
            this.thumb = thumb;
            this.ctime = ctime;
        }
    }

    public static class AddrMeta {
        public String addr;
        public String token;
        public long groupId;

        AddrMeta(String addr, String token, long groupId) {
            this.addr = addr;
            this.token = token;
            this.groupId = groupId;
        }
    }

    public static class GetEvidenceInfoResp {
        public long requestId;
        public int errNo;
        public String errMsg;
        public String createAddr;
        public String txId;
        public JSONObject assetInfo;
        public long cTime;

        GetEvidenceInfoResp(long requestId, int errNo, String errMsg, String createAddr, String txId, JSONObject assetInfo, long cTime) {
            this.requestId = requestId;
            this.errNo = errNo;
            this.errMsg = errMsg;
            this.createAddr = createAddr;
            this.txId = txId;
            this.assetInfo = assetInfo;
            this.cTime = cTime;
        }
    }

    public static class History {
        long assetId;
        int type;
        long shardId;
        long price;
        String txId;
        String from;
        String to;
        long ctime;
        public History(long assetId, int type, long shardId, long price, String txId, String from, String to, long ctime) {
            this.assetId = assetId;
            this.type = type;
            this.shardId = shardId;
            this.price = price;
            this.txId = txId;
            this.from = from;
            this.to = to;
            this.ctime = ctime;
        }

        public long getAssetId() {
            return assetId;
        }

        public void setAssetId(long assetId) {
            this.assetId = assetId;
        }

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public long getShardId() {
            return shardId;
        }

        public void setShardId(long shardId) {
            this.shardId = shardId;
        }

        public long getPrice() {
            return price;
        }

        public void setPrice(long price) {
            this.price = price;
        }

        public String getTxId() {
            return txId;
        }

        public void setTxId(String txId) {
            this.txId = txId;
        }

        public String getFrom() {
            return from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public long getCtime() {
            return ctime;
        }

        public void setCtime(long ctime) {
            this.ctime = ctime;
        }
    }

    public static class ShardDiffInfo {
        public long assetId;
        public long shardId;
        public int operate;
        public String title;
        public Thumb[] thumb;
        public long ctime;

        ShardDiffInfo(long assetId, long shardId, int operate, String title, Thumb[] thumb, long ctime) {
            this.assetId = assetId;
            this.shardId = shardId;
            this.operate = operate;
            this.title = title;
            this.thumb = thumb;
            this.ctime = ctime;
        }
    }

    public static class ShardAssetInfo {
        public String title;
        public int assetCate;
        public Thumb[] thumb;
        public String shortDesc;
        public String createAddr;
        public long groupId;

        ShardAssetInfo(String title, int assetCate, Thumb[] thumb, String shortDesc, String createAddr, long groupId) {
            this.title = title;
            this.assetCate = assetCate;
            this.thumb = thumb;
            this.shortDesc = shortDesc;
            this.createAddr = createAddr;
            this.groupId = groupId;
        }
    }

    public static class ShardMeta {
        public long assetId;
        public long shardId;
        public String ownerAddr;
        public long uid;
        public long price;
        public int status;
        public String txId;
        public ShardAssetInfo assetInfo;
        public long ctime;

        ShardMeta(long assetId, long shardId, String ownerAddr, long uid, long price, int status, String txId, ShardAssetInfo assetInfo, long ctime) {
            this.assetId = assetId;
            this.shardId = shardId;
            this.ownerAddr = ownerAddr;
            this.uid = uid;
            this.price = price;
            this.status = status;
            this.txId = txId;
            this.assetInfo = assetInfo;
            this.ctime = ctime;
        }
    }

    public static class QueryShardsResp {
        public long requestId;
        public int errNo;
        public String errMsg;
        public ShardMeta meta;

        QueryShardsResp(long requestId, int errNo, String errMsg, ShardMeta meta) {
            this.requestId = requestId;
            this.errNo = errNo;
            this.errMsg = errMsg;
            this.meta = meta;
        }
    }

    public static class GrantShardResp {
        public long requestId;
        public int errNo;
        public String errMsg;
        public long assetId;
        public long shardId;

        GrantShardResp(long requestId, int errNo, String errMsg, long assetId, long shardId) {
            this.requestId = requestId;
            this.errNo = errNo;
            this.errMsg = errMsg;
            this.assetId = assetId;
            this.shardId = shardId;
        }
    }

    public static class Urls {
        public String icon;
        public String url1;
        public String url2;
        public String url3;

        Urls(String icon, String url1, String url2, String url3) {
            this.icon = icon;
            this.url1 = url1;
            this.url2 = url2;
            this.url3 = url3;
        }
    }

    public static class Thumb {
        public Urls urls;
        public String width;
        public String height;

        Thumb(Urls urls, String width, String height) {
            this.urls = urls;
            this.width = width;
            this.height = height;
        }
    }

    public static class AssetMeta {
        public long assetId;
        public int assetCate;
        public String title;
        public Thumb[] thumb;
        public String shortDesc;
        public String longDesc;
        public JSONArray imgDesc;
        public JSONArray assetUrl;
        public int amount;
        public long price;
        public int status;
        public String assetExt;
        public String createAddr;
        public long groupId;
        public String txId;

        AssetMeta(long assetId, int assetCate, String title, Thumb[] thumb, String shortDesc, String longDesc, JSONArray imgDesc, JSONArray assetUrl, int amount, long price, int status, String assetExt, String createAddr, long groupId, String txId) {
            this.assetId = assetId;
            this.assetCate = assetCate;
            this.title = title;
            this.thumb = thumb;
            this.shortDesc = shortDesc;
            this.longDesc = longDesc;
            this.imgDesc = imgDesc;
            this.assetUrl = assetUrl;
            this.amount = amount;
            this.price = price;
            this.status = status;
            this.assetExt = assetExt;
            this.createAddr = createAddr;
            this.groupId = groupId;
            this.txId = txId;
        }
    }

    public static class QueryAssetResp {
        public long requestId;
        public int errNo;
        public String errMsg;
        public AssetMeta meta;

        QueryAssetResp(long requestId, int errNo, String errMsg, AssetMeta meta) {
            this.requestId = requestId;
            this.errNo = errNo;
            this.errMsg = errMsg;
            this.meta = meta;
        }
    }

    public static class CreateAssetResp {
        public long requestId;
        public int errNo;
        public String errMsg;
        public long assetId;

        CreateAssetResp(long requestId, int errNo, String errMsg, long assetId) {
            this.requestId = requestId;
            this.errNo = errNo;
            this.errMsg = errMsg;
            this.assetId = assetId;
        }
    }

    public static class UploadFile {
        public String link;
        public GetStokenResp resp;
        public RequestRes res;

        UploadFile(String link, GetStokenResp resp, RequestRes res) {
            this.link = link;
            this.resp = resp;
            this.res = res;
        }
    }

    public static class AccessInfo {
        public String bucket;
        public String endPoint;
        public String objectPath;
        public String accessKeyId;
        public String secreteAccessKey;
        public String sessionToken;
        public String createTime;
        public String expiration;

        AccessInfo(String bucket, String endPoint, String objectPath, String accessKeyId, String secreteAccessKey, String sessionToken, String createTime, String expiration) {
            this.bucket = bucket;
            this.endPoint = endPoint;
            this.objectPath = objectPath;
            this.accessKeyId = accessKeyId;
            this.secreteAccessKey = secreteAccessKey;
            this.sessionToken = sessionToken;
            this.createTime = createTime;
            this.expiration = expiration;
        }
    }

    public static class GetStokenResp {
        public long requestId;
        public int errNo;
        public String errMsg;
        public AccessInfo accessInfo;

        GetStokenResp(long requestId, int errNo, String errMsg, AccessInfo accessInfo) {
            this.requestId = requestId;
            this.errNo = errNo;
            this.errMsg = errMsg;
            this.accessInfo = accessInfo;
        }
    }

    public static class GetAddrByUnionIdResp {
        public long requestId;
        public int errNo;
        public String errMsg;
        public String address;

        GetAddrByUnionIdResp(long requestId, int errNo, String errMsg, String address) {
            this.requestId = requestId;
            this.errNo = errNo;
            this.errMsg = errMsg;
            this.address = address;
        }
    }

    public static class BdBoxRegisterResp {
        public long requestId;
        public int errNo;
        public String errMsg;
        public String address;
        public String mnemonic;
        public int isNew;

        BdBoxRegisterResp(long requestId, int errNo, String errMsg, String address, String mnemonic, int isNew) {
            this.requestId = requestId;
            this.errNo = errNo;
            this.errMsg = errMsg;
            this.address = address;
            this.mnemonic = mnemonic;
            this.isNew = isNew;
        }
    }

    public static class AssetInfo {
        @JSONField(
                name = "asset_cate"
        )
        public int assetCate;
        @JSONField(
                name = "title"
        )
        public String title;
        @JSONField(
                name = "thumb"
        )
        public String[] thumb;
        @JSONField(
                name = "short_desc"
        )
        public String shortDesc;
        @JSONField(
                name = "img_desc"
        )
        public String[] imgDesc;
        @JSONField(
                name = "asset_url"
        )
        public String[] assetUrl;
        @JSONField(
                name = "long_desc"
        )
        public String longDesc;
        @JSONField(
                name = "asset_ext"
        )
        public String assetExt;
        @JSONField(
                name = "group_id"
        )
        public long groupId;

        public AssetInfo(int assetCate, String title, String[] thumb, String shortDesc, String[] imgDesc, String[] assetUrl, String longDesc, String assetExt, long groupId) {
            this.assetCate = assetCate;
            this.title = title;
            this.thumb = thumb;
            this.shortDesc = shortDesc;
            this.imgDesc = imgDesc;
            this.assetUrl = assetUrl;
            this.longDesc = longDesc;
            this.assetExt = assetExt;
            this.groupId = groupId;
        }
    }
}

