package com.liquidnet.service.sweet.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import com.liquidnet.service.sweet.config.WechatMaConfigure;
import com.liquidnet.service.sweet.config.WechatMpConfigure;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.bean.WxOAuth2UserInfo;
import me.chanjar.weixin.common.bean.oauth2.WxOAuth2AccessToken;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class SweetWechatService {
    @Autowired
    WechatMaConfigure wechatMaConfigure;

    @Autowired
    WechatMpConfigure wechatMpConfigure;

    /**
     * 小程序--------------
     */
    public WxMaJscode2SessionResult sessionInfo(String code, Integer anum) throws WxErrorException {
        WxMaService wxMaService = wechatMaConfigure.getWxMaService(anum);
        log.info("isAccessTokenExpired：[{}] ", wxMaService.getWxMaConfig().isAccessTokenExpired());
        log.info("getAccessToken：[{}] ", wxMaService.getWxMaConfig().getAccessToken());
        return wxMaService.getUserService().getSessionInfo(code);
    }

    public WxMaUserInfo userInfo(String sessionKey, String encryptedData, String iv, Integer anum) {
        WxMaService wxMaService = wechatMaConfigure.getWxMaService(anum);
        return wxMaService.getUserService().getUserInfo(sessionKey, encryptedData, iv);
    }

    public WxMaPhoneNumberInfo phoneNumberInfo(String sessionKey, String encryptedData, String iv, Integer anum) {
        WxMaService wxMaService = wechatMaConfigure.getWxMaService(anum);
        return wxMaService.getUserService().getPhoneNoInfo(sessionKey, encryptedData, iv);
    }

    public WxMaPhoneNumberInfo getPhoneNumber(String code, Integer anum) {
        WxMaService wxMaService = wechatMaConfigure.getWxMaService(anum);
        try {
            return wxMaService.getUserService().getPhoneNumber(code);
        } catch (Exception e) {
            log.error("getPhoneNumber error", e);
            return null;
        }
    }

    /**
     * 服务号--------------
     */
    public WxOAuth2AccessToken wxOauth2AccessToken(String code, Integer type) throws WxErrorException {
        WxMpService wxMpService = wechatMpConfigure.getWxMpService(type);
        log.info("isAccessTokenExpired：[{}] ", wxMpService.getWxMpConfigStorage().isAccessTokenExpired());
        log.info("getAccessToken：[{}] ", wxMpService.getWxMpConfigStorage().getAccessToken());
        return wxMpService.getOAuth2Service().getAccessToken(code);
    }

    public WxOAuth2UserInfo mpUserInfo(String code, Integer type) throws WxErrorException {
        WxMpService wxMpService = wechatMpConfigure.getWxMpService(type);
        WxOAuth2AccessToken wxOAuth2AccessToken = wxMpService.getOAuth2Service().getAccessToken(code);
        return wxMpService.getOAuth2Service().getUserInfo(wxOAuth2AccessToken, "zh_CN");
    }
}
