package com.liquidnet.service.feign.platform.api;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(
        name = "liquidnet-service-platform",
        contextId = "FeignPlatformCandyDemoteClient",
        path = "platform",
        url = "${liquidnet.service.platform.url}",
        fallback = FallbackFactory.Default.class
)
public interface FeignPlatformCandyDemoteClient {

    @GetMapping("cdemote/ucoupon")
    ResponseDto<Object> queryForUserCouponBasicDto(@RequestParam("currentUid") String currentUid);

    @GetMapping("cdemote/ccoupon")
    ResponseDto<Object> queryForCommonCouponBasicDto(@RequestParam("ucreatedAtStr") String ucreatedAtStr);
}
