package com.liquidnet.service.kylin.dto.param;

import com.liquidnet.service.kylin.dto.vo.mongo.KylinCheckUserPerformanceVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class CheckPerformanceRelationParam implements Cloneable {
    @ApiModelProperty(value = "演出id")
    @NotNull(message = "演出ID不能为空")
    private String performanceId;
    @ApiModelProperty(value = "可下载时间")
    @NotNull(message = "可下载时间不能为空")
    private String canDownTime;

    private static final CheckPerformanceRelationParam obj = new CheckPerformanceRelationParam();
    public static CheckPerformanceRelationParam getNew() {
        try {
            return (CheckPerformanceRelationParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CheckPerformanceRelationParam();
        }
    }
}
