package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
public class SweetArtistsUrl implements Serializable,Cloneable{
    private static final long serialVersionUID = 1L;
    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * artists_id
     */
    private String artistsId;
    /**
     * url
     */
    private String url;
    /**
     * 类型 1图片 2视频
     */
    private String type;
    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    private static final SweetArtistsUrl obj = new SweetArtistsUrl();
    public static SweetArtistsUrl getNew() {
        try {
            return (SweetArtistsUrl) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetArtistsUrl();
        }
    }
}
