package com.liquidnet.service.galaxy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 退款订单信息表
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class DragonOrderRefundLogs implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 退款订单id
     */
    private String orderRefundId;

    /**
     * 退款类型
     */
    private String refundType;

    /**
     * 退款通知内容
     */
    private String content;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    /**
     * 删除时间
     */
    private LocalDateTime deletedAt;


}
