drop TABLE if exists `platform_oss_files`;
create table platform_oss_files
(
    `mid`           int(11) unsigned NOT NULL AUTO_INCREMENT,
    `oss_files_id`  varchar(255)     NOT NULL DEFAULT '' COMMENT 'oss_files_id',
    `file_name`     varchar(255)     NOT NULL DEFAULT '' COMMENT '源文件名称',
    `content_type`  varchar(255)     NOT NULL DEFAULT '' COMMENT '文件类型',
    `size`          int              NOT NULL DEFAULT 0 COMMENT '文件大小',
    `md5str`        varchar(255)     NOT NULL DEFAULT '' COMMENT 'md5值判断文件是否相同',
    `oss_path`      varchar(255)     NOT NULL DEFAULT '' COMMENT '文件地址（阿里oss）',
    `buck_type`     tinyint          NOT NULL DEFAULT '0' COMMENT 'buck_type',
    `uploader_uid`  varchar(255)     NOT NULL DEFAULT '' COMMENT '上传人id',
    `uploader_name` varchar(255)     NOT NULL DEFAULT '' COMMENT '上传人姓名',
    `created_at`    timestamp        NULL     DEFAULT NULL,
    `updated_at`    timestamp        NULL     DEFAULT NULL,
    KEY `kylin_oss_files_id_index` (`oss_files_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '阿里云OSS上传记录';

alter table platform_oss_files add video_img varchar(255) NOT NULL DEFAULT '' COMMENT '视频截帧图片文件地址（阿里oss）' after oss_path;