package com.liquidnet.service.adam.constant;

public class AdamEnum {
    /**
     * 业务账户
     */
    public enum BizAcct {
        IMHX("imhx", "即时通讯-环信"),
        NFT_ZX("nft_zx", "NFT-至信链"),
        NFT_XUPER("nft_xuper", "NFT-百度超级链"),
        ;
        private final String code;
        private final String desc;

        BizAcct(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }

    /**
     * 业务账户状态
     */
    public enum BizAcctStatus {
        UNOPEN(0, "账户未开通"),
        OPENED(1, "账户已开通"),
        ;
        private final Integer val;
        private final String desc;

        BizAcctStatus(Integer val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public Integer getVal() {
            return val;
        }

        public String getDesc() {
            return desc;
        }
    }

    /**
     * 业务账户模块
     */
    public enum BizAcctWork {
        USER("user", "用户模块"),
        ;
        private final String val;
        private final String desc;

        BizAcctWork(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public String getDesc() {
            return desc;
        }
    }
}
