package com.liquidnet.service.candy.dto;

import com.liquidnet.service.candy.entity.CandyUserCouponAssoc;
import lombok.Data;

import java.io.Serializable;

@Data
public class CandyUserCouponAssocDto implements Serializable, Cloneable {
    private static final long serialVersionUID = -5500626839150118876L;

    /**
     * 关联人证件类型：1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证
     */
    private Integer idType;

    /**
     * 关联人姓名
     */
    private String idName;

    /**
     * 关联人证件号码
     */
    private String idNo;

    private static final CandyUserCouponAssocDto obj = new CandyUserCouponAssocDto();
    public static CandyUserCouponAssocDto getNew() {
        try {
            return (CandyUserCouponAssocDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyUserCouponAssocDto();
        }
    }

    public CandyUserCouponAssocDto copy(CandyUserCouponAssoc userCouponAssoc) {
        if (null == userCouponAssoc) return this;
        this.setIdType(userCouponAssoc.getIdType());
        this.setIdName(userCouponAssoc.getIdName());
        this.setIdNo(userCouponAssoc.getIdNo());
        return this;
    }
}
