package com.liquidnet.service.candy.mapper;

import com.liquidnet.service.candy.dto.CandyCouponRuleDto;
import com.liquidnet.service.candy.entity.CandyCouponRule;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 券适用规则 Mapper 接口
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
public interface CandyCouponRuleMapper extends BaseMapper<CandyCouponRule> {

    /**
     * <p>
     * 查取指定券适用规则列表
     * </p>
     * 限定规则状态[state = 1]
     *
     * @param couponId 券ID
     * @return List<CandyCouponRuleDto>
     */
    List<CandyCouponRuleDto> selectForCouponRuleDto(@Param("couponId") String couponId);

    /**
     * <p>
     * 查取指定券适用规则列表
     * </p>
     * 限定规则状态[state = 1]
     *
     * @param couponIdList 券ID列表
     * @return List<CandyCouponRuleDto>
     */
    List<CandyCouponRuleDto> selectForCouponRuleDto(@Param("couponIdList") List<String> couponIdList);
}
