package com.liquidnet.service.executor.main.handler;

import com.liquidnet.service.feign.sweet.task.FeignSweetWechatClient;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * sweet
 */
@Component
public class SweetWechatTaskHandler {
    @Autowired
    private FeignSweetWechatClient feignSweetWechatClient;

    @XxlJob(value = "sev-sweet:sendMsg")
    public void sendWechatMsgHandler() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignSweetWechatClient.send().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-sweet:sendSubMsg")
    public void sendSubMsgHandler() {
        try {
            String jobParam = XxlJobHelper.getJobParam();
            String[] paramArray = jobParam.split(",");

            for (String type : paramArray) {
                Object data = feignSweetWechatClient.sendSubMsg(Integer.parseInt(type)).getData();
                XxlJobHelper.log("type:{},结果:{}", data);
            }
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

}
