package com.liquidnet.service.consumer.slowly.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.slowly.receiver.ConsumerGoblinUserOrderRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

@Configuration
public class ConsumerGoblinUserOrderRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerGoblinUserOrderRdsReceiver consumerGoblinUserOrderRdsReceiver;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Bean
    public List<Subscription> subscriptionSqlUserOrder(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.GOBLIN_USER_ORDER_OPERA;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinUserOrderRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

//    /**
//     * 缺票登记
//     *
//     * @param listenerContainer
//     * @param t
//     * @return
//     */
//    private Subscription receiveGoblinUserOrder(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.GoblinQueue.GOBLIN_USER_ORDER_OPERA.getGroup(), getConsumerName(MQConst.GoblinQueue.GOBLIN_USER_ORDER_OPERA.name() + t)),
//                StreamOffset.create(MQConst.GoblinQueue.GOBLIN_USER_ORDER_OPERA.getKey(), ReadOffset.lastConsumed()), consumerGoblinUserOrderRdsReceiver);
//    }
//
//    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */
//
//    /* -------------------------------------------------------- ｜ 缺票登记 */
//
//    @Bean
//    public Subscription subscriptionGoblinUserOrder0(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveGoblinUserOrder(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }
//
////    @Bean
////    public Subscription subscriptionGoblinUserOrder1(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveGoblinUserOrder(listenerContainer, 1);
////        listenerContainer.start();
////        return subscription;
////    }
////
////    @Bean
////    public Subscription subscriptionGoblinUserOrder2(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveGoblinUserOrder(listenerContainer, 2);
////        listenerContainer.start();
////        return subscription;
////    }

    /* -------------------------------------------------------- ｜  */
}
