package com.liquidnet.service.consumer.slowly.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.slowly.receiver.ConsumerKylinSqlStationRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

import static com.liquidnet.service.base.constant.MQConst.KylinQueue.SQL_STATION;

@Configuration
public class ConsumerKylinSqlStationRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerKylinSqlStationRdsReceiver consumerKylinSqlStationRdsReceiver;

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Bean
    public List<Subscription> subscriptionSqlStation(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.KylinQueue stream = SQL_STATION;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerKylinSqlStationRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }


//    /**
//     * 验票更新
//     *
//     * @param listenerContainer
//     * @param t
//     * @return
//     */
//    private Subscription receiveSqlStation(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(SQL_STATION.getGroup(), getConsumerName(SQL_STATION.name() + t)),
//                StreamOffset.create(SQL_STATION.getKey(), ReadOffset.lastConsumed()), consumerKylinSqlStationRdsReceiver);
//    }
//
//    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */
//
//    /* -------------------------------------------------------- ｜ 验票更新 */
//
//    @Bean
//    public Subscription subscriptionSqlStation0(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlStation(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }
//
////    @Bean
////    public Subscription subscriptionSqlStation1(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveSqlStation(listenerContainer, 1);
////        listenerContainer.start();
////        return subscription;
////    }
////
////    @Bean
////    public Subscription subscriptionSqlStation2(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveSqlStation(listenerContainer, 2);
////        listenerContainer.start();
////        return subscription;
////    }
////
////    @Bean
////    public Subscription subscriptionSqlStation3(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveSqlStation(listenerContainer, 3);
////        listenerContainer.start();
////        return subscription;
////    }
////
////    @Bean
////    public Subscription subscriptionSqlStation4(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveSqlStation(listenerContainer, 4);
////        listenerContainer.start();
////        return subscription;
////    }

    /* -------------------------------------------------------- ｜  */
}
